.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "ALTER DATABASE" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER DATABASE \- change a database
.SH SYNOPSIS
.sp
.nf
ALTER DATABASE \fIname\fR SET \fIvariable\fR { TO | = } { \fIvalue\fR | DEFAULT }
ALTER DATABASE \fIname\fR RESET \fIvariable\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER DATABASE\fR is used to change the session
default of a run-time configuration variable for a
PostgreSQL database. Whenever a new
session is subsequently started in that database, the specified
value becomes the session default value.
The database-specific default
overrides whatever setting is present in \fIpostgresql.conf\fR
or has been received from the postmaster.
.PP
Only a superuser or the database owner can change the session defaults for a
database.
.SS "PARAMETERS"
.PP
.TP
\fB\fIname\fB\fR
The name of the database whose session defaults are to be altered.
.TP
\fB\fIvariable\fB\fR
.TP
\fB\fIvalue\fB\fR
Set the session default for this database of the specified
configuration variable to the given value. If
\fIvalue\fR is DEFAULT
or, equivalently, RESET is used, the
database-specific variable setting is removed and the system-wide
default
setting will be inherited in new sessions. Use RESET
ALL to clear all settings.

See SET [\fBset\fR(l)] and the
\fIAdministrator's Guide\fR for more
information about allowed variable names and values.
.PP
.SH "DIAGNOSTICS"
.PP
.TP
\fBALTER DATABASE\fR
Message returned if the alteration was successful.
.TP
\fBERROR: database "dbname" does not exist\fR
Error message returned if the specified database is not known
to the system.
.PP
.SH "NOTES"
.PP
Using ALTER USER [\fBalter_user\fR(l)],
it is also possible to tie a session default to a specific user
rather than a database. User-specific settings override database-specific
ones if there is a conflict.
.SH "EXAMPLES"
.PP
To disable index scans by default in the database
test:
.sp
.nf
ALTER DATABASE test SET enable_indexscan TO off;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER DATABASE\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
ALTER USER [\fBalter_user\fR(l)], CREATE DATABASE [\fBcreate_database\fR(l)], DROP DATABASE [\fBdrop_database\fR(l)], SET [\fBset\fR(l)]

