/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/server/CleanLogRunnable.java,v $
 * $Author: asullivan $ $Revision: 1.1.1.1 $ $Date: 2003/08/26 19:02:21 $
 *
 */

package com.postgres.replic.server;

import com.postgres.replic.server.props.*;
import com.postgres.replic.util.*;
import com.postgres.replic.util.struct.*;
import com.postgres.util.config.*;
import com.postgres.util.jdbc.*;
import java.sql.*;


public class CleanLogRunnable extends AbstractReplicationRunnable
implements Runnable {

    public CleanLogRunnable(ServerProps serverProps,
    ConnectionPoolProps connPoolProps,
    ConnectionPool masterPool,
    ConnectionPool slavePool) throws ReplicationException {
        super(serverProps, connPoolProps, masterPool, slavePool);
    }


    public void run()  {
        try {
            while (true && !(getSignal() == STOP)) {
                getLogger().debug("CleanLogRunnable::run cleanLog");
                getRserv().cleanLog(getServerProps().getHowOldLog());
                Thread.sleep(getServerProps().getCleanLogInterval());
            }
        } catch (InterruptedException ie) {
            getLogger().error("CleanLogRunnable::run: InterruptedException: calling destroy");
            destroy();
        } catch (Exception e) {
            getLogger().error("CleanLogRunnable::run: ", e);
        } finally {

        }
    }
}
