/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;

public class Move
extends Copy {
    protected void doFileOperations() {
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            this.log("Moving " + this.fileCopyMap.size() + " files to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String toFile = (String)this.fileCopyMap.get(fromFile);
                try {
                    this.log("Moving " + fromFile + " to " + toFile, this.verbosity);
                    this.project.copyFile(fromFile, toFile, this.filtering, this.forceOverwrite);
                    File f = new File(fromFile);
                    if (f.delete()) continue;
                    throw new BuildException("Unable to delete file " + f.getAbsolutePath());
                }
                catch (IOException ioe) {
                    String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.location);
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int count = 0;
            while (e.hasMoreElements()) {
                File d = new File((String)e.nextElement());
                if (d.exists()) continue;
                if (!d.mkdirs()) {
                    this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                    continue;
                }
                ++count;
            }
            if (count > 0) {
                this.log("Moved " + count + " empty directories to " + this.destDir.getAbsolutePath());
            }
        }
        if (this.filesets.size() > 0) {
            e = this.filesets.elements();
            while (e.hasMoreElements()) {
                FileSet fs = (FileSet)e.nextElement();
                File dir = fs.getDir(this.project);
                if (!this.okToDelete(dir)) continue;
                this.deleteDir(dir);
            }
        }
    }

    protected boolean okToDelete(File d) {
        String[] list = d.list();
        if (list == null) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                if (!this.okToDelete(f)) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void deleteDir(File d) {
        String[] list = d.list();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(d, s);
            if (!f.isDirectory()) {
                throw new BuildException("UNEXPECTED ERROR - The file " + f.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(f);
            ++i;
        }
        this.log("Deleting directory " + d.getAbsolutePath(), this.verbosity);
        if (!d.delete()) {
            throw new BuildException("Unable to delete directory " + d.getAbsolutePath());
        }
    }

    public Move() {
        this.forceOverwrite = true;
    }
}

