/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Chmod
extends ExecuteOn {
    private FileSet defaultSet = new FileSet();
    private boolean havePerm = false;

    public void setFile(File src) {
        FileSet fs = new FileSet();
        fs.setDir(new File(src.getParent()));
        fs.createInclude().setName(src.getName());
        this.addFileset(fs);
    }

    public void setDir(File src) {
        this.defaultSet.setDir(src);
    }

    public void setPerm(String perm) {
        this.createArg().setValue(perm);
        this.havePerm = true;
    }

    public PatternSet.NameEntry createInclude() {
        return this.defaultSet.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        return this.defaultSet.createExclude();
    }

    public PatternSet createPatternSet() {
        return this.defaultSet.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.defaultSet.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.defaultSet.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.defaultSet.setDefaultexcludes(useDefaultExcludes);
    }

    protected void checkConfiguration() {
        if (!this.havePerm) {
            throw new BuildException("Required attribute perm not set in chmod", this.location);
        }
        if (this.defaultSet.getDir(this.project) != null) {
            this.addFileset(this.defaultSet);
        }
        super.checkConfiguration();
    }

    public void setExecutable(String e) {
        throw new BuildException(this.taskType + " doesn't support the executable attribute", this.location);
    }

    public void setCommand(String e) {
        throw new BuildException(this.taskType + " doesn't support the command attribute", this.location);
    }

    protected boolean isValidOs() {
        return System.getProperty("path.separator").equals(":") && (!System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").endsWith("X")) && super.isValidOs();
    }

    public Chmod() {
        super.setExecutable("chmod");
        super.setParallel(true);
    }
}

