/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.jdbc2.Connection;
import org.postgresql.jdbc2.ResultSetMetaData;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.largeobject.PGblob;
import org.postgresql.util.PSQLException;

public class ResultSet
extends org.postgresql.ResultSet
implements java.sql.ResultSet {
    public ResultSet(Connection conn, Field[] fields, Vector tuples, String status, int updateCount) {
        super(conn, fields, tuples, status, updateCount);
    }

    public boolean absolute(int index) throws SQLException {
        if (index < 0) {
            index = this.rows.size() + index;
        }
        if (index == 0 || index > this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(index);
        return true;
    }

    public void afterLast() throws SQLException {
        if (this.rows.size() > 0) {
            this.current_row = this.rows.size();
        }
    }

    public void beforeFirst() throws SQLException {
        if (this.rows.size() > 0) {
            this.current_row = -1;
        }
    }

    public void cancelRowUpdates() throws SQLException {
        throw Driver.notImplemented();
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void close() throws SQLException {
    }

    public void deleteRow() throws SQLException {
        throw Driver.notImplemented();
    }

    public int findColumn(String columnName) throws SQLException {
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].name.equalsIgnoreCase(columnName)) {
                return i + 1;
            }
            ++i;
        }
        throw new PSQLException("postgresql.res.colname", (Object)columnName);
    }

    public boolean first() throws SQLException {
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = 0;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public Array getArray(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            BigDecimal val;
            try {
                val = new BigDecimal(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)s);
            }
            try {
                return val.setScale(scale);
            }
            catch (ArithmeticException arithmeticException) {
                throw new PSQLException("postgresql.res.badbigdec", (Object)s);
            }
        }
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] b = this.getBytes(columnIndex);
        if (b != null) {
            return new ByteArrayInputStream(b);
        }
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public Blob getBlob(int i) throws SQLException {
        return new PGblob(this.connection, this.getInt(i));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            char c = s.charAt(0);
            return c == 't' || c == 'T';
        }
        return false;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badbyte", (Object)s);
            }
        }
        return 0;
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (!this.wasNullFlag && this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getInt(columnIndex));
            byte[] buf = lob.read(lob.size());
            lob.close();
            return buf;
        }
        return this.this_row[columnIndex - 1];
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public Clob getClob(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public int getConcurrency() throws SQLException {
        throw Driver.notImplemented();
    }

    public String getCursorName() throws SQLException {
        return this.connection.getCursorName();
    }

    public Date getDate(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return new Date(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new PSQLException("postgresql.res.baddate", new Integer(e.getErrorOffset()), s);
        }
    }

    public Date getDate(int i, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Date getDate(String c, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(c), cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.baddouble", (Object)s);
            }
        }
        return 0.0;
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public int getFetchDirection() throws SQLException {
        throw Driver.notImplemented();
    }

    public int getFetchSize() throws SQLException {
        throw Driver.notImplemented();
    }

    public float getFloat(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Float.valueOf(s).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badfloat", (Object)s);
            }
        }
        return 0.0f;
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public int getInt(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badint", (Object)s);
            }
        }
        return 0;
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public int getKeysetSize() throws SQLException {
        throw Driver.notImplemented();
    }

    public long getLong(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badlong", (Object)s);
            }
        }
        return 0L;
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        return new ResultSetMetaData(this.rows, this.fields);
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return new Boolean(this.getBoolean(columnIndex));
            }
            case 5: {
                return new Integer(this.getInt(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.mod - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
        }
        return this.connection.getObject(field.getTypeName(), this.getString(columnIndex));
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    public Ref getRef(int i) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public int getRow() throws SQLException {
        return this.current_row + 1;
    }

    public short getShort(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badshort", (Object)s);
            }
        }
        return 0;
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public Statement getStatement() throws SQLException {
        throw Driver.notImplemented();
    }

    public String getString(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange");
        }
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        return new String(this.this_row[columnIndex - 1]);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s != null) {
            try {
                if (s.length() != 5 && s.length() != 8) {
                    throw new NumberFormatException("Wrong Length!");
                }
                int hr = Integer.parseInt(s.substring(0, 2));
                int min = Integer.parseInt(s.substring(3, 5));
                int sec = s.length() == 5 ? 0 : Integer.parseInt(s.substring(6));
                return new Time(hr, min, sec);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PSQLException("postgresql.res.badtime", (Object)s);
            }
        }
        return null;
    }

    public Time getTime(int i, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Time getTime(String c, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(c), cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:sszzz");
        try {
            return new Timestamp(df.parse(s).getTime());
        }
        catch (ParseException e) {
            throw new PSQLException("postgresql.res.badtimestamp", new Integer(e.getErrorOffset()), s);
        }
    }

    public Timestamp getTimestamp(int i, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String c, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(c), cal);
    }

    public int getType() throws SQLException {
        throw Driver.notImplemented();
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void insertRow() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean isAfterLast() throws SQLException {
        return this.current_row >= this.rows.size() && this.rows.size() > 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.current_row < 0 && this.rows.size() > 0;
    }

    public boolean isFirst() throws SQLException {
        return this.current_row == 0 && this.rows.size() >= 0;
    }

    public boolean isLast() throws SQLException {
        return this.current_row == this.rows.size() - 1 && this.rows.size() > 0;
    }

    public boolean last() throws SQLException {
        if (this.rows.size() <= 0) {
            return false;
        }
        this.current_row = this.rows.size() - 1;
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void moveToCurrentRow() throws SQLException {
        throw Driver.notImplemented();
    }

    public void moveToInsertRow() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean next() throws SQLException {
        if (++this.current_row >= this.rows.size()) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public boolean previous() throws SQLException {
        if (--this.current_row < 0) {
            return false;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        return true;
    }

    public void refreshRow() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.current_row + rows);
    }

    public boolean rowDeleted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowInserted() throws SQLException {
        throw Driver.notImplemented();
    }

    public boolean rowUpdated() throws SQLException {
        throw Driver.notImplemented();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setKeysetSize(int keys) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateRow() throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw Driver.notImplemented();
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }
}

